uniform sampler2D 			posTex;
uniform sampler2DShadow 	shadowmap;

varying vec2 		texcoord;
uniform float 		lightrange;
uniform float		cOfs;

uniform vec4		LTM0,
					LTM1,
					LTM2,
					LTM3;

varying vec2		VPOS;

void main()
{
	vec4	XYproj;	

	vec4 pos = texture2D(posTex,texcoord.st);
	pos.xy=VPOS.xy*-pos.z;
	pos.w=1.0;

	float shadowOcc;
	//gl_FragColor.r=1.0;
	
	vec3 projcoords;
	/*float lrangeMin=lightrange-1000.0;
	if( -pos.z/lrangeMin > 1.0 )
	{*/
		// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
		XYproj.x = dot(pos,LTM0);
		XYproj.y = dot(pos,LTM1);
		XYproj.z = dot(pos,LTM2);
		XYproj.w = dot(pos,LTM3);

		projcoords.xy=XYproj.xy;
		projcoords.z=XYproj.z-0.002;
		///////////////////////////////////

		float dOfs = cOfs*0.5;
		shadowOcc=0.0;

		vec3 shadowcoords;
		shadowcoords.z=projcoords.z;

		shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
		shadowOcc+=shadow2D(shadowmap,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
		shadowOcc+=shadow2D(shadowmap,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
		shadowOcc+=shadow2D(shadowmap,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
		shadowOcc+=shadow2D(shadowmap,shadowcoords).r;

		shadowOcc *= 0.25;
		
	//	shadowOcc=mix(1.0,shadowOcc,( clamp( (-pos.z-lrangeMin)/(lightrange-lrangeMin),0.0,1.0) ));
		//gl_FragColor.g*=shadowOcc;
	//}
	
	gl_FragColor.r=max(shadowOcc,0.0);
}
